#%define  LINUXDIST %(eval ibhost-linux-dist-name)
#%define  KERNEL_VER %(eval uname -r | tr - _)

Summary: Voltaire Enhanced MVAPICH for OpenIB.
Name: vltmpi-OPENIB
Version: 24
Release: 1
License: Commercial, Voltaire Inc. (C) 2005, 2006.
Vendor: Voltaire Inc.
Group: HPC
                                                                                                                            
Source: vltmpi-OPENIB-24-1.src.tar.bz2
                                                                                                                            
Packager: Olga Shern <olgas@voltaire.com>
Provides: Voltaire Enhanced MVAPICH for OpenIB.
AutoReq: no
AutoProv: no

%description
Voltaire enhanced MVAPICH for OpenIB package.
This package is based on Ohio State university MPI for IB implementation.
It is intended to run over OpenIB drivers.
For more details visit us at: http://www.voltaire.com/

%prep

CONFIG_GEN_ARCH=$(uname -m)
                                                                                                                            
%setup -n vltmpi-OPENIB-24-1

%build 

CONFIG_GEN_ARCH=$(uname -m)

if [[ -z $VOLT_TOP ]]; then
    export VOLT_TOP=/opt/vltmpi/OPENIB
fi
                                                                                                                            
if [[ ! -d $VOLT_TOP ]]; then
	mkdir -p $VOLT_TOP
elif [[ `ls $VOLT_TOP/* 1>/dev/null 2>/dev/null` ]]; then	
		echo "You are trying to install mpi to existing, not empty directory, $VOLT_TOP"
		echo "Please set VOLT_TOP to another directory or remove $VOLT_TOP and then try again" 
		exit 1
fi

if [[ "${CONFIG_GEN_ARCH}" == "i386" ||  "${CONFIG_GEN_ARCH}" == "i686" || "${CONFIG_GEN_ARCH}" == "x86" ]]; then
	./mpi-build-i386
elif [ "${CONFIG_GEN_ARCH}" == "x86_64" ]; then
	./mpi-build-x86_64
elif [ "${CONFIG_GEN_ARCH}" == "ia64" ]; then
	./mpi-build-ia64
elif [ "${CONFIG_GEN_ARCH}" == "ppc64" ]; then
        ./mpi-build-ppc64
fi

echo "" > /tmp/mpi-all-files.list
find ${VOLT_TOP} -type f -print >> /tmp/mpi-all-files.list
echo ${VOLT_TOP}/mpi >> /tmp/mpi-all-files.list
find ${VOLT_TOP}/mpi.*  -type l -print >> /tmp/mpi-all-files.list

%files -f /tmp/mpi-all-files.list

%pre 

KERNEL_VER=`uname -r`

if [[ (`ls /lib/modules/"${KERNEL_VER}"/kernel/drivers/infiniband/core/*  2>/dev/null`)
   && (`ls /lib/modules/"${KERNEL_VER}"/kernel/drivers/infiniband/hw/* 2>/dev/null`)  ]]; then
        echo -n ""
elif [[ (`ls /lib/modules/"${KERNEL_VER}"/extra/core/* 2>/dev/null`)
   &&  (`ls /lib/modules/"${KERNEL_VER}"/extra/hw/* 2>/dev/null`) ]]; then
        echo -n ""
else
        echo "Infiniband modules are not installed on this machine
              MPI installation aborted ..."
        exit
fi
                                                                                                                                                             

%post

if [[ -z $VOLT_TOP ]]; then
    export VOLT_TOP=/opt/vltmpi/OPENIB
fi
                                                                                                                            
#if [[ -z $IBHOME ]]; then 
#	export IBHOME=/usr/local
#fi

#There is no need for this because we add compilation flags 
# Add Mpi's shared libraries directory to ld.so.conf

#if ! grep -q "${VOLT_TOP}/${MPI_DIR_NAME}" /etc/ld.so.conf ; then
#     echo "${VOLT_TOP}/${MPI_DIR_NAME}/lib" >> /etc/ld.so.conf
#fi

#if ! grep -q "${VOLT_TOP}/${MPI_DIR_NAME}/lib/shared" /etc/ld.so.conf ; then
#     echo "${VOLT_TOP}/${MPI_DIR_NAME}/lib/shared" >> /etc/ld.so.conf
#fi

#if ! grep -q "$IBHOME" /etc/ld.so.conf ; then
#     echo "$IBHOME/lib" >> /etc/ld.so.conf
#fi 
                                                                                                                            
#( ldconfig >/dev/null 2>&1 )
#if [[ $? -ne 0 ]]; then
#    echo -ne "\nERROR: ldconfig did not complete successfully ! \n\n"
#fi

if [[ ! `grep ${VOLT_TOP}/mpi/bin /etc/profile` ]]; then
        echo 'export PATH="'${VOLT_TOP}/mpi/bin':${PATH}"' >> /etc/profile
fi

. /etc/profile
%postun

if [[ -z $VOLT_TOP ]]; then
    export VOLT_TOP=/opt/vltmpi/OPENIB
fi

rm -rf $VOLT_TOP

